/////////////////////////////////////////////////////////////
// CINEMA SDK : MESSAGES																	 //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4D_CUSTOMDATATYPEPLUGIN_H
#define __C4D_CUSTOMDATATYPEPLUGIN_H

#include "ge_math.h"
#include "c4d_customdatatype.h"
#include "c4d_baseplugin.h"

struct CUSTOMDATATYPEPLUGIN : public STATICPLUGIN
{
	LONG							disclevel;
										
	CustomDataType*		(CustomDataTypeClass::*AllocData						)();
	void							(CustomDataTypeClass::*FreeData							)(CustomDataType* data);
																																
	Bool							(CustomDataTypeClass::*CopyData							)(const CustomDataType* src,CustomDataType* dest,GeAliasTrans *aliastrans);
	LONG							(CustomDataTypeClass::*Compare							)(const CustomDataType* d1,const CustomDataType* d2);
																																
	Bool							(CustomDataTypeClass::*WriteData						)(const CustomDataType *d,HyperFile *hf);
	Bool							(CustomDataTypeClass::*ReadData							)(CustomDataType *d,HyperFile *hf,LONG level);
																																
	CHAR*							(CustomDataTypeClass::*GetResourceSym				)();

	LONG							(CustomDataTypeClass::*EX_GETCUSTOMGUIPLUGIN)();

	CustomProperty*		(CustomDataTypeClass::*GetProperties				)();
	void							(CustomDataTypeClass::*GetDefaultProperties	)(BaseContainer &data);
										
	LONG							(CustomDataTypeClass::*GetConversionsFrom		)(LONG *&table);
	GvError 					(CustomDataTypeClass::*ConvertFromGv				)(LONG type,const void *const src,LONG cpu_id,CustomDataType *dst);
	GvError						(CustomDataTypeClass::*ConvertFromGeData		)(LONG type,const GeData &src,CustomDataType *dst);
										
	LONG							(CustomDataTypeClass::*GetConversionsTo			)(LONG *&table);
	GvError 					(CustomDataTypeClass::*ConvertToGv					)(LONG type,const CustomDataType *src,void *dst,LONG cpu_id);
	GvError						(CustomDataTypeClass::*ConvertToGeData			)(LONG type,const CustomDataType *src,GeData &dst);
										
	GvValueFlags			(CustomDataTypeClass::*GetCalculationFlags	)();
	GvError 					(CustomDataTypeClass::*Calculate						)(LONG calculation,const CustomDataType *src1, const CustomDataType *src2, CustomDataType *dst, Real parm1);

	GV_VALUE_HANDLER*	(CustomDataTypeClass::*GetGvValueHandler		)();

	Bool							(CustomDataTypeClass::*ConvertGeDataToGv		)(const GeData &src,void *dst,LONG cpu_id);
	Bool							(CustomDataTypeClass::*ConvertGvToGeData		)(const void *const src,LONG cpu_id,GeData &dst);

	LONG							(CustomDataTypeClass::*GetValueID						)();
	LONG							(CustomDataTypeClass::*GetDataID						)();

	Bool							(CustomDataTypeClass::*_GetDescription			)(const CustomDataType *data,Description &res,LONG &flags,const BaseContainer &parentdescription,DescID *singledescid);
	Bool							(CustomDataTypeClass::*GetParameter					)(const CustomDataType *data,const DescID &id,GeData &t_data,LONG &flags);
	Bool							(CustomDataTypeClass::*SetDParameter				)(CustomDataType *data,const DescID &id,const GeData &t_data,LONG &flags);
	Bool							(CustomDataTypeClass::*GetEnabling					)(const CustomDataType *data,const DescID &id,GeData &t_data,LONG &flags,const BaseContainer *itemdesc);
	Bool							(CustomDataTypeClass::*SetAnimatedParameter )(CustomDataType *data,const DescID &id,const GeData &t_data1,const GeData &t_data2,Real mix,LONG flags);
	Bool							(CustomDataTypeClass::*GetAnimatedParameter )(const CustomDataType *data,const DescID &id,GeData &t_data1,GeData &t_data2,Real &mix,LONG flags);
	void							(CustomDataTypeClass::*CheckData						)(const BaseContainer &bc,GeData &data);

	void*	reserved[(64-30)*C4DPL_MEMBERMULTIPLIER-1];
};

struct RESOURCEDATATYPEPLUGIN : public STATICPLUGIN
{
	LONG									disclevel;
												
	CHAR*									(ResourceDataTypeClass::*GetResourceSym					)();
	CustomProperty*				(ResourceDataTypeClass::*GetProperties					)();
	void									(ResourceDataTypeClass::*GetDefaultProperties		)(BaseContainer &data);
	CUSTOMDATATYPEPLUGIN* (ResourceDataTypeClass::*GetCustomDataTypePlugin)();
	Bool									(ResourceDataTypeClass::*GetDescription					)(const CustomDataType *data,Description &res,LONG &flags,const BaseContainer &parentdescription,DescID *singledescid);
	void									(ResourceDataTypeClass::*CheckData							)(const BaseContainer &bc,GeData &data);

	void*	reserved[(32-6)*C4DPL_MEMBERMULTIPLIER-1];
};

#define CallCustomDataTypePlugin(plug,fnc)		(((CustomDataTypeClass*)(((CUSTOMDATATYPEPLUGIN*)plug->GetPluginStructure())->adr))->*((CUSTOMDATATYPEPLUGIN*)plug->GetPluginStructure())->fnc)
#define CallResourceDataTypePlugin(plug,fnc)	(((ResourceDataTypeClass*)(((RESOURCEDATATYPEPLUGIN*)plug->GetPluginStructure())->adr))->*((RESOURCEDATATYPEPLUGIN*)plug->GetPluginStructure())->fnc)
	
#define CallCustomDataType(plug,fnc)   (((CustomDataTypeClass*)(plug->adr))->*plug->fnc)
#define CallResourceDataType(plug,fnc) (((ResourceDataTypeClass*)(plug->adr))->*plug->fnc)

CUSTOMDATATYPEPLUGIN   *FindCustomDataTypePlugin(LONG type);
RESOURCEDATATYPEPLUGIN *FindResourceDataTypePlugin(LONG type);

LONG GetDataType(LONG resourcetype);

BaseContainer GetCustomDataTypeDefault(LONG type);

#endif
